/*
 * Decompiled with CFR 0.152.
 */
package com.goby56.wakes.config.gui;

import com.goby56.wakes.config.gui.ColorPickerScreen;
import com.goby56.wakes.render.WakeColor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Vector2f;

public class ColorPicker
extends class_339 {
    private static final class_2960 PICKER_BG_TEXTURE = class_2960.method_60655((String)"wakes", (String)"textures/picker_background.png");
    private static final class_2960 PICKER_RIM_TEXTURE = class_2960.method_60655((String)"wakes", (String)"textures/picker_rim.png");
    private static final class_2960 PICKER_KNOB_TEXTURE = class_2960.method_60655((String)"wakes", (String)"textures/picker_knob.png");
    private static final int pickerKnobDim = 7;
    private final Map<String, Bounded> widgets = new HashMap<String, Bounded>();
    private final AABB colorPickerBounds;
    private Consumer<WakeColor> changedColorListener;
    private final Vector2f pickerPos = new Vector2f();
    private final Vector2f pickerCenter = new Vector2f();
    private final float pickerRadius;

    public ColorPicker(ColorPickerScreen screenContext, int x, int y, int width, int height) {
        super(x, y, width, height, class_2561.method_30163((String)""));
        this.colorPickerBounds = new AABB(0.16666667f, 0.0f, 0.8333333f, 0.6666667f, x, y, width, height);
        this.pickerCenter.x = (float)this.colorPickerBounds.x + (float)this.colorPickerBounds.width / 2.0f;
        this.pickerCenter.y = (float)this.colorPickerBounds.y + (float)this.colorPickerBounds.height / 2.0f;
        this.pickerRadius = (float)this.colorPickerBounds.width / 2.0f;
        this.widgets.put("valueSlider", new ColorPickerSlider(new AABB(0.0f, 0.6666667f, 1.0f, 0.8333333f, x, y, width, height), "Brightness", this, SliderUpdateType.VALUE));
        this.widgets.put("alphaSlider", new ColorPickerSlider(new AABB(0.5f, 0.8333333f, 1.0f, 1.0f, x, y, width, height), "Opacity", this, SliderUpdateType.OPACITY));
        this.widgets.put("hexInputField", new HexInputField(new AABB(0.0f, 0.8333333f, 0.5f, 1.0f, x, y, width, height), this, class_310.method_1551().field_1772));
        screenContext.addWidget(this);
        for (Bounded widget : this.widgets.values()) {
            screenContext.addWidget(widget.getWidget());
        }
        this.setActive(false);
    }

    public void setActive(boolean active) {
        this.field_22763 = this.field_22764 = active;
        for (Bounded widget : this.widgets.values()) {
            widget.setActive(active);
        }
    }

    public void setColor(WakeColor currentColor, WidgetUpdateFlag updateFlag) {
        if (updateFlag.equals((Object)WidgetUpdateFlag.ONLY_HEX)) {
            this.widgets.get("hexInputField").setColor(currentColor);
            return;
        }
        float[] hsv = Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null);
        float x = (float)((double)this.pickerCenter.x + (double)(hsv[1] * this.pickerRadius) * Math.cos(hsv[0]));
        float y = (float)((double)this.pickerCenter.y + (double)(hsv[1] * this.pickerRadius) * Math.sin(hsv[0]));
        this.pickerPos.set(x, y);
        for (String widgetKey : this.widgets.keySet()) {
            if (updateFlag.equals((Object)WidgetUpdateFlag.IGNORE_HEX) && widgetKey.equals("hexInputField")) {
                this.changedColorListener.accept(currentColor);
                continue;
            }
            this.widgets.get(widgetKey).setColor(currentColor);
        }
    }

    public void registerListener(Consumer<WakeColor> changedListener) {
        this.changedColorListener = changedListener;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_339 hexInput = this.widgets.get("hexInputField").getWidget();
        if (hexInput.method_25370()) {
            return hexInput.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        class_339 hexInput = this.widgets.get("hexInputField").getWidget();
        if (hexInput.method_25370()) {
            return hexInput.method_25400(chr, modifiers);
        }
        return super.method_25400(chr, modifiers);
    }

    public void method_25348(double mouseX, double mouseY) {
        class_339 focusedWidget = null;
        for (Bounded widget : this.widgets.values()) {
            widget.getWidget().method_25365(false);
            if (!widget.getBounds().contains((int)mouseX, (int)mouseY)) continue;
            focusedWidget = widget.getWidget();
        }
        if (focusedWidget != null) {
            focusedWidget.method_25365(true);
            focusedWidget.method_25348(mouseX, mouseY);
            return;
        }
        this.updatePickerPos(mouseX, mouseY);
        super.method_25348(mouseX, mouseY);
    }

    public void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        mouseX = Math.min((double)(this.method_46426() + this.field_22758), Math.max((double)this.method_46426(), mouseX));
        mouseY = Math.min((double)(this.method_46427() + this.field_22759), Math.max((double)this.method_46427(), mouseY));
        for (Bounded widget : this.widgets.values()) {
            if (!widget.getWidget().method_25370()) continue;
            widget.getWidget().method_25349(mouseX, mouseY, deltaX, deltaY);
            return;
        }
        this.updatePickerPos(mouseX, mouseY);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    public Vector2f getPolarPos(double mouseX, double mouseY) {
        double x = mouseX - (double)this.pickerCenter.x;
        double y = mouseY - (double)this.pickerCenter.y;
        float r = (float)Math.min(Math.sqrt(x * x + y * y), (double)(this.pickerRadius * 0.9f));
        float v = (float)Math.atan2(y, x);
        return new Vector2f(r, v);
    }

    public void updatePickerPos(double mouseX, double mouseY) {
        Vector2f rv = this.getPolarPos(mouseX, mouseY);
        this.pickerPos.set((double)this.pickerCenter.x + (double)rv.x * Math.cos(rv.y), (double)this.pickerCenter.y + (double)rv.x * Math.sin(rv.y));
        this.updateColor();
    }

    public void updateColor() {
        Vector2f rv = this.getPolarPos(this.pickerPos.x, this.pickerPos.y);
        float hue = (float)(1.0 - ((double)rv.y + 1.5707963267948966) / (Math.PI * 2));
        float saturation = rv.x / this.pickerRadius;
        float value = ((ColorPickerSlider)this.widgets.get("valueSlider").getWidget()).getValue();
        float opacity = ((ColorPickerSlider)this.widgets.get("alphaSlider").getWidget()).getValue();
        WakeColor newColor = new WakeColor(hue, saturation, value, opacity);
        this.setColor(newColor, WidgetUpdateFlag.ONLY_HEX);
        this.changedColorListener.accept(newColor);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22763) {
            return;
        }
        context.method_25290(PICKER_BG_TEXTURE, this.colorPickerBounds.x - 1, this.colorPickerBounds.y - 1, 0.0f, 0.0f, this.colorPickerBounds.width, this.colorPickerBounds.height, this.colorPickerBounds.width, this.colorPickerBounds.height);
        this.drawHSVCircle();
        context.method_25290(PICKER_RIM_TEXTURE, this.colorPickerBounds.x - 1, this.colorPickerBounds.y - 1, 0.0f, 0.0f, this.colorPickerBounds.width, this.colorPickerBounds.height, this.colorPickerBounds.width, this.colorPickerBounds.height);
        int d = 7;
        Vector2f rv = this.getPolarPos(this.pickerPos.x, this.pickerPos.y);
        this.pickerPos.set((double)this.pickerCenter.x + (double)rv.x * Math.cos(rv.y), (double)this.pickerCenter.y + (double)rv.x * Math.sin(rv.y));
        int pickerX = (int)((double)this.pickerCenter.x + (double)rv.x * Math.cos(rv.y));
        int pickerY = (int)((double)this.pickerCenter.y + (double)rv.x * Math.sin(rv.y));
        context.method_25290(PICKER_KNOB_TEXTURE, pickerX - 3, pickerY - 3, 0.0f, 0.0f, d, d, d, d);
    }

    private void drawHSVCircle() {
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
        int radius = this.colorPickerBounds.width / 2;
        int x = this.colorPickerBounds.x + radius;
        int y = this.colorPickerBounds.y + radius;
        int segments = 24;
        float value = ((ColorPickerSlider)this.widgets.get("valueSlider").getWidget()).getValue();
        float opacity = ((ColorPickerSlider)this.widgets.get("alphaSlider").getWidget()).getValue() * 0.5f;
        WakeColor middleColor = new WakeColor(0.0f, 0.0f, value, opacity);
        buffer.method_22912((float)x, (float)y, 0.0f).method_39415(middleColor.argb);
        for (int i = 0; i <= segments; ++i) {
            double a = (double)i / (double)segments * Math.PI * 2.0 - 1.5707963267948966;
            float hue = (float)i / (float)segments;
            int color = new WakeColor((float)hue, (float)1.0f, (float)value, (float)opacity).argb;
            buffer.method_22912((float)((int)((double)x - Math.cos(a) * (double)radius)), (float)((int)((double)y + Math.sin(a) * (double)radius)), 0.0f).method_39415(color);
        }
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    protected void method_47399(class_6382 builder) {
    }

    public static class AABB {
        public int x;
        public int y;
        public int width;
        public int height;

        public AABB(float fracX1, float fracY1, float fracX2, float fracY2, int globX, int globY, int totWidth, int totHeight) {
            this.x = Math.round(fracX1 * (float)totWidth) + globX + 1;
            this.y = Math.round(fracY1 * (float)totHeight) + globY + 1;
            this.width = Math.round((fracX2 - fracX1) * (float)totWidth) - 2;
            this.height = Math.round((fracY2 - fracY1) * (float)totHeight) - 2;
        }

        public boolean contains(int x, int y) {
            return this.x <= x && x < this.x + this.width && this.y <= y && y < this.y + this.height;
        }
    }

    private static class ColorPickerSlider
    extends class_357
    implements Bounded {
        protected AABB bounds;
        private final SliderUpdateType type;
        private final ColorPicker colorPicker;

        public ColorPickerSlider(AABB bounds, String text, ColorPicker colorPicker, SliderUpdateType type) {
            super(bounds.x, bounds.y, bounds.width, bounds.height, class_2561.method_30163((String)text), 1.0);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.type = type;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.field_22753 = this.type.equals((Object)SliderUpdateType.HUE) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[0] : (this.type.equals((Object)SliderUpdateType.SATURATION) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[1] : (this.type.equals((Object)SliderUpdateType.VALUE) ? (double)Color.RGBtoHSB(currentColor.r, currentColor.g, currentColor.b, null)[2] : (double)((float)currentColor.a / 255.0f)));
        }

        public float getValue() {
            return (float)this.field_22753;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            context.method_52706(this.method_52716(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            context.method_52706(this.method_52717(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
            int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            this.method_49604(context, class_310.method_1551().field_1772, 2, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }

        protected void method_25346() {
        }

        protected void method_25344() {
            this.colorPicker.updateColor();
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    public static enum SliderUpdateType {
        HUE,
        SATURATION,
        VALUE,
        OPACITY;

    }

    private static class HexInputField
    extends class_342
    implements Bounded {
        protected AABB bounds;
        private final ColorPicker colorPicker;
        private final Pattern hexColorRegex;
        private boolean autoUpdate = false;

        public HexInputField(AABB bounds, ColorPicker colorPicker, class_327 textRenderer) {
            super(textRenderer, bounds.x, bounds.y, bounds.width, bounds.height, (class_2561)class_2561.method_43473());
            this.method_1880(9);
            this.bounds = bounds;
            this.colorPicker = colorPicker;
            this.method_1890(HexInputField::validHex);
            this.hexColorRegex = Pattern.compile("#[a-f0-9]{7,9}", 2);
        }

        protected void method_1874(String newText) {
            if (this.autoUpdate) {
                return;
            }
            if (this.hexColorRegex.matcher(newText).find()) {
                this.colorPicker.setColor(new WakeColor(newText), WidgetUpdateFlag.IGNORE_HEX);
            }
            super.method_1874(newText);
        }

        private static boolean validHex(String text) {
            if (text.length() > 9) {
                return false;
            }
            for (char c : text.toLowerCase().toCharArray()) {
                if (Character.digit(c, 16) != -1 || c == '#') continue;
                return false;
            }
            return true;
        }

        @Override
        public void setActive(boolean active) {
            this.field_22763 = this.field_22764 = active;
        }

        public boolean method_25400(char chr, int modifiers) {
            this.autoUpdate = false;
            return super.method_25400(chr, modifiers);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            this.autoUpdate = false;
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        @Override
        public void setColor(WakeColor currentColor) {
            this.autoUpdate = true;
            this.method_1852(currentColor.toHex());
        }

        @Override
        public AABB getBounds() {
            return this.bounds;
        }

        @Override
        public class_339 getWidget() {
            return this;
        }
    }

    public static interface Bounded {
        public AABB getBounds();

        public class_339 getWidget();

        public void setActive(boolean var1);

        public void setColor(WakeColor var1);
    }

    public static enum WidgetUpdateFlag {
        ALL,
        ONLY_HEX,
        IGNORE_HEX;

    }
}

